
import cantera as ct
import numpy as np
import pandas as pd
import xlsxwriter as xw

#Definimos las constantes:

Fr = 1
XNH3 = 0.91833
Yres = 0.1
air_n2_o2_molar_ratio = 3.76 #fracción molar del nitrógeno en el aire
To = 298 #Temperatura ambiente (K)
Po = 101325 #Presión ambiente (Pa)

#Obtenemos el resto de variables del Excel:
    
datos = pd.read_excel('Res_P_24_P_T_avg.xlsx', header=None)

P = datos[3].tolist()
Tq = datos[2].tolist()
Ang = datos[0].tolist()
t = datos[1].tolist()

#Filtramos 

for g in range(0,len(t)):
    if t[g] > 0:
        break

P = P[g:]
Tq = Tq[g:]
Ang = Ang[g:]
t = t[g:]


# if t_filtrado:
#     t_filtrado[0] = 0

#Definimos vectores solución

points = len(P)
Sal_xH2=np.zeros(points)
Sal_xH=np.zeros(points)
Sal_xO=np.zeros(points)
Sal_xO2=np.zeros(points)
Sal_xH2O=np.zeros(points)
Sal_xCH4=np.zeros(points)
Sal_xCO=np.zeros(points)
Sal_xCO2=np.zeros(points)
Sal_xN=np.zeros(points)
Sal_xNH3=np.zeros(points)
Sal_xNO=np.zeros(points)
Sal_xNO2=np.zeros(points)
Sal_xN2O=np.zeros(points)
Sal_xN2=np.zeros(points)

#Definimos el gas

gas1 = ct.Solution('C:/Users/usuario/Desktop/Cantera/CKM_Okafor_NH3_chem.yaml')
gas2 = ct.Solution('C:/Users/usuario/Desktop/Cantera/CKM_Okafor_NH3_chem.yaml')
gas3 = ct.Solution('C:/Users/usuario/Desktop/Cantera/CKM_Okafor_NH3_chem.yaml')
gas4 = ct.Solution('C:/Users/usuario/Desktop/Cantera/CKM_Okafor_NH3_chem.yaml')

#Calculamos el equilibrio

gas1.set_equivalence_ratio(Fr, {'CH4':1-XNH3, 'NH3':XNH3}, {'O2': 1, 'N2': air_n2_o2_molar_ratio}) #composición de la mezcla
gas1.TP=(To,Po)
gas2.set_equivalence_ratio(Fr, {'CH4':1-XNH3, 'NH3':XNH3}, {'O2': 1, 'N2': air_n2_o2_molar_ratio}) #composición de la mezcla
gas2.TP=(To,Po)
gas2.equilibrate('TP')

gas3.Y = gas1.Y * (1 - Yres) + gas2.Y * Yres

for i in range(len(P)):

    Presiones = P[i]
    Tempq = Tq[i]

    gas3.TP=(Tempq,Presiones) #definición de la mezcla con los valores de presión y temperatura
    gas3.equilibrate('TP')
    gas3.X

    contador = i

    Sal_xH2[contador]=gas3.X[gas3.species_index('H2')]
    Sal_xH[contador]=gas3.X[gas3.species_index('H')]
    Sal_xO2[contador]=gas3.X[gas3.species_index('O2')]
    Sal_xH2O[contador]=gas3.X[gas3.species_index('H2O')]
    Sal_xCH4[contador]=gas3.X[gas3.species_index('CH4')]
    Sal_xCO[contador]=gas3.X[gas3.species_index('CO')]
    Sal_xCO2[contador]=gas3.X[gas3.species_index('CO2')]
    Sal_xN[contador]=gas3.X[gas3.species_index('N')]
    Sal_xNH3[contador]=gas3.X[gas3.species_index('NH3')]
    Sal_xNO[contador]=gas3.X[gas3.species_index('NO')]
    Sal_xNO2[contador]=gas3.X[gas3.species_index('NO2')]
    Sal_xN2O[contador]=gas3.X[gas3.species_index('N2O')]
    Sal_xN2[contador]=gas3.X[gas3.species_index('N2')]


#print(Sal_xNO)


#Reaccionamos el gas
gas4.Y = gas3.Y
reactor = ct.IdealGasReactor(gas4)
sim = ct.ReactorNet([reactor])

gas4.TP = (298,1*10**5)
gas4.equilibrate('TP')

Sal_xH2_des=[]
Sal_xH_des=[]
Sal_xO2_des=[]
Sal_xH2O_des=[]
Sal_xCH4_des=[]
Sal_xCO_des=[]
Sal_xCO2_des=[]
Sal_xN_des=[]
Sal_xNH3_des=[]
Sal_xNO_des=[]
Sal_xNO2_des=[]
Sal_xN2O_des=[]
Sal_xN2_des=[]

for j in range(0,len(t)):

    dt = t[j] if j == 0 else (t[j] - t[j-1])

    gas4.TP = Tq[j], P[j]

    reactor.syncState()
    sim.advance(sim.time + dt)
    reactor.syncState()
    
    Sal_xH2_des.append(gas4.X[gas4.species_index('H2')])
    Sal_xH_des.append(gas4.X[gas4.species_index('H')])
    Sal_xO2_des.append(gas4.X[gas4.species_index('O2')])
    Sal_xH2O_des.append(gas4.X[gas4.species_index('H2O')])
    Sal_xCH4_des.append(gas4.X[gas4.species_index('CH4')])
    Sal_xCO_des.append(gas4.X[gas4.species_index('CO')])
    Sal_xCO2_des.append(gas4.X[gas4.species_index('CO2')])
    Sal_xN_des.append(gas4.X[gas4.species_index('N')])
    Sal_xNH3_des.append(gas4.X[gas4.species_index('NH3')])
    Sal_xNO_des.append(gas4.X[gas4.species_index('NO')])
    Sal_xNO2_des.append(gas4.X[gas4.species_index('NO2')])
    Sal_xN2O_des.append(gas4.X[gas4.species_index('N2O')])
    Sal_xN2_des.append(gas4.X[gas4.species_index('N2')])


# Crear un nuevo archivo Excel
workbook = xw.Workbook("Resultados_P_24.xlsx")
worksheet = workbook.add_worksheet("Resultados")

# Escribir encabezados
worksheet.write("A1", "Ángulo(º)")
worksheet.write("B1", "xH2 Equilibrio")
worksheet.write("C1", "xH2 Desequilibrio")
worksheet.write("D1", "xH Equilibrio")
worksheet.write("E1", "xH Desequilibrio")
worksheet.write("F1", "xO2 Equilibrio")
worksheet.write("G1", "xO2 Desequilibrio")
worksheet.write("H1", "xH2O Equilibrio")
worksheet.write("I1", "xH2O Desequilibrio")
worksheet.write("J1", "xCH4 Equilibrio")
worksheet.write("K1", "xCH4 Desequilibrio")
worksheet.write("L1", "xCO Equilibrio")
worksheet.write("M1", "xCO Desequilibrio")
worksheet.write("N1", "xCO2 Equilibrio")
worksheet.write("O1", "xCO2 Desequilibrio")
worksheet.write("P1", "xN Equilibrio")
worksheet.write("Q1", "xN Desequilibrio")
worksheet.write("R1", "xNH3 Equilibrio")
worksheet.write("S1", "xNH3 Desequilibrio")
worksheet.write("T1", "xNO Equilibrio")
worksheet.write("U1", "xNO Desequilibrio")
worksheet.write("V1", "xNO2 Equilibrio")
worksheet.write("W1", "xNO2 Desequilibrio")
worksheet.write("X1", "xN2O Equilibrio")
worksheet.write("Y1", "xN2O Desequilibrio")
worksheet.write("Z1", "xN2 Equilibrio")
worksheet.write("AA1", "xN2 Desequilibrio")


# Agregar datos
fila = 1
for k in range(len(P)):
    worksheet.write(fila, 0, Ang[k])
    worksheet.write(fila, 1, Sal_xH2[k])
    worksheet.write(fila, 2, Sal_xH2_des[k])
    worksheet.write(fila, 3, Sal_xH[k])
    worksheet.write(fila, 4, Sal_xH_des[k])
    worksheet.write(fila, 5, Sal_xO2[k])
    worksheet.write(fila, 6, Sal_xO2_des[k])
    worksheet.write(fila, 7, Sal_xH2O[k])
    worksheet.write(fila, 8, Sal_xH2O_des[k])
    worksheet.write(fila, 9, Sal_xCH4[k])
    worksheet.write(fila, 10, Sal_xCH4_des[k])
    worksheet.write(fila, 11, Sal_xCO[k])
    worksheet.write(fila, 12, Sal_xCO_des[k])
    worksheet.write(fila, 13, Sal_xCO2[k])
    worksheet.write(fila, 14, Sal_xCO2_des[k])
    worksheet.write(fila, 15, Sal_xN[k])
    worksheet.write(fila, 16, Sal_xN_des[k])
    worksheet.write(fila, 17, Sal_xNH3[k])
    worksheet.write(fila, 18, Sal_xNH3_des[k])
    worksheet.write(fila, 19, Sal_xNO[k])
    worksheet.write(fila, 20, Sal_xNO_des[k])
    worksheet.write(fila, 21, Sal_xNO2[k])
    worksheet.write(fila, 22, Sal_xNO2_des[k])
    worksheet.write(fila, 23, Sal_xN2O[k])
    worksheet.write(fila, 24, Sal_xN2O_des[k])
    worksheet.write(fila, 25, Sal_xN2[k])
    worksheet.write(fila, 26, Sal_xN2_des[k])

    fila += 1

# Cerrar y guardar
workbook.close()


    
